(function() {	
	// toon/verberg de uitleg
	var uitlegTabje = document.querySelector(".uitleg > h2");
	if (uitlegTabje) {
		// door te klikken
		uitlegTabje.addEventListener("click", function(){
			toggleUitleg();
		});

		// en ook met de enter knop
		uitlegTabje.addEventListener("keydown", function(e){
			if (e.which == 13) {
				toggleUitleg();
			}
		});
	}
	
	// header in beeld
	iniHeaderInteractionObserver();
    
	// de links in de uitleg
	iniTabIndex();
    
	// het dames tekstje
	iniDames();
})();

function iniHeaderInteractionObserver() {
	const config = {
		rootMargin: '-80px 0px 0px',
		threshold: 1
	};
	const deP = document.querySelector('p');

	var observer = new IntersectionObserver( function(entry) {
		if (entry[0].isIntersecting) {
			document.body.classList.remove("small");
		} else {
			document.body.classList.add("small");
		}
	}, config);

	observer.observe(deP);
}

function toggleUitleg(){
	document.body.classList.toggle("show-uitleg");
	toggleTabIndex( document.querySelectorAll(".uitleg a, body > header a, main a") );
	toggleContenteditable( document.querySelectorAll("body > header [contenteditable]") );
}


function iniTabIndex(){
	toggleTabIndex( document.querySelectorAll(".uitleg a") );
}


function toggleTabIndex(tabElements){
	tabElements.forEach(function(tabElement){
		if (tabElement.tabIndex != 0) {
			tabElement.tabIndex = 0;
		} else {
			tabElement.tabIndex = -1;
		}
	});
}


function toggleContenteditable(editElements){
    editElements.forEach(function(editElement){
        if( editElement.getAttribute("contenteditable") == "true" ){
            editElement.setAttribute("contenteditable", false);
        } else {
            editElement.setAttribute("contenteditable", true);
        }
    });
}


function iniDames(){
	var dames = document.querySelector("header h1 div");
	
	if (localStorage.getItem('damesText')) {
		dames.innerHTML = localStorage.getItem('damesText');
        updateDamesString();
	}
	
	dames.addEventListener("keydown", function(e){
		if (e.which == 13 || e.which == 27 ) {
			e.preventDefault();
			e.target.blur();
		} else if ( damesLength(e.target.innerHTML) > 11 && 
                   e.which != 8 && /* backspace */
                   e.which != 9 && /* tab */
                   e.which != 16 && /* shift */
                   e.which != 17 && /* ctrl */
                   e.which != 18 && /* alt */
                   e.which != 19 && /* pause/break */
                   e.which != 20 && /* caps lock */
                   e.which != 33 && /* caps lock */
                   e.which != 34 && /* page up */
                   e.which != 37 && /* page down */
                   e.which != 38 && /* up arrow */
                   e.which != 39 && /* right arrow */
                   e.which != 40 && /* down arrow */
                   e.which != 45 && /* insert */
                   e.which != 46 && /* delete */
                   e.which != 91 && /* left window key */
                   e.which != 92 && /* right window key */
                   e.which != 93 && /* select key */
                   e.which != 144 && /* num lock */
                   e.which != 145 /* scroll lock */
                  ) {
			e.preventDefault();
			document.querySelector("audio").play();
		}
	});
	
	dames.addEventListener("keyup", function(e){
		localStorage.setItem('damesText', e.target.innerHTML);
        updateDamesString();
	});
	
	dames.addEventListener("blur", function(e){
		var damesString = e.target.innerHTML.replace(/&nbsp;/g, ' ').replace(/\s/g, "");
		if (damesString == 0 || e.target.innerHTML == "<br>") {
			e.target.innerHTML = "Dames";
			localStorage.setItem('damesText', e.target.innerHTML);
            updateDamesString();
		}
	});
    
    function updateDamesString(){
        if(document.querySelector(".uitleg h3 span")){
            document.querySelector(".uitleg h3 span").innerHTML = localStorage.getItem('damesText');   
        }
    }


    function damesLength(damesString) {
        damesString = damesString.replace(/&nbsp;/g, ' ');
        return(damesString.length);
    }
}